package w83b.w83bManager;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.commons.lang.StringUtils;

import w83b.w83bBeans.W83bResultadosBean;
import w83b.w83bDAO.W83bFactoriaDAO;
import w83b.w83bUtilidadesComunes.W83bClsConstantes;
import w83b.w83bUtilidadesComunes.W83bUtilidades;


// TODO: Auto-generated Javadoc
/**
 * The Class W83bResultados.
 */
public class W83bResultados implements W83bIResultados {
	/* (non-Javadoc)
	 * @see w83b.w83bManager.W83bIResultados#buscarResCentroSindicato(w83b.w83bBeans.W83bResultadosBean)
	 */
	public java.util.List buscarResCentroSindicato(w83b.w83bBeans.W83bResultadosBean param,boolean contar) throws Exception{
	
		List lista= W83bFactoriaDAO.getResultadosDAO().buscarResCentroSindicato(param,contar);
		
		return lista;	
	}
	
	/* (non-Javadoc)
	 * @see w83b.w83bManager.W83bIResultados#buscarCuadroResultados(w83b.w83bBeans.W83bResultadosBean)
	 */
	public java.util.Map buscarCabeceraCuadroResultados(w83b.w83bBeans.W83bResultadosBean param) throws Exception{
		
		Map mapa = new HashMap();
		if (param.getTerritorio()!=null&&!"null".equals(param.getTerritorio())&&!"".equals(param.getTerritorio())){
			param.setNumTrabajadores("todos");
			mapa.put("cabecera", W83bFactoriaDAO.getResultadosDAO().w83bcabdelegsindconv(param));
		}
		else{
			param.setTerritorio("todos");
			param.setNumTrabajadores("todos");
			mapa.put("cabecera", W83bFactoriaDAO.getResultadosDAO().w83bcabdelegsindconv(param));
		}
		return mapa;	
	}
	public java.util.Map buscarCabeceraCuadroResClasif(w83b.w83bBeans.W83bResultadosBean param) throws Exception{
		
		Map mapa = new HashMap();
		if (param.getTerritorio()!=null&&!"null".equals(param.getTerritorio())&&!"".equals(param.getTerritorio())){
			param.setNumTrabajadores("<=49");
			mapa.put("cabeceramenos49", W83bFactoriaDAO.getResultadosDAO().w83bcabdelegsindconv(param));
			param.setNumTrabajadores(">49");
			mapa.put("cabeceramas49", W83bFactoriaDAO.getResultadosDAO().w83bcabdelegsindconv(param));
		}
		else{
			param.setTerritorio("todos");
			param.setNumTrabajadores("<=49");
			mapa.put("cabeceramenos49", W83bFactoriaDAO.getResultadosDAO().w83bcabdelegsindconv(param));
			param.setNumTrabajadores(">49");
			mapa.put("cabeceramas49", W83bFactoriaDAO.getResultadosDAO().w83bcabdelegsindconv(param));
		}
		return mapa;	
	}
	public java.util.Map buscarCuadroResultados(w83b.w83bBeans.W83bResultadosBean param) throws Exception{
	
		Map mapa = new HashMap();
		param.setNumTrabajadores("todos");
		if (param.getTerritorio()!=null&&!"null".equals(param.getTerritorio())&&!"".equals(param.getTerritorio())){
			mapa=W83bFactoriaDAO.getResultadosDAO().buscarCuadroResultados(param);
			mapa.put(param.getTerritorio(),mapa.get("sindicatos"));
			param.setCaso("1");
		}
		else{
			param.setTerritorio("todos");
			mapa=W83bFactoriaDAO.getResultadosDAO().buscarCuadroResultados(param);
			mapa.put("todos",mapa.get("sindicatos"));
			param.setCaso("3");
		}
		mapa.put("delegadosmenorigual49", mapa.get("delegadosmenorigual49"));
		mapa.put("delegadosmenorigual49", mapa.get("delegadosmenorigual49"));
		return mapa;	
	}
	public java.util.Map buscarCuadroResClasifMenorIgual49(w83b.w83bBeans.W83bResultadosBean param) throws Exception{
		
		Map mapa = new HashMap();
		if (param.getTerritorio()!=null&&!"null".equals(param.getTerritorio())&&!"".equals(param.getTerritorio())){
			param.setNumTrabajadores("<=49");
			mapa.put(param.getTerritorio()+"|menos49",W83bFactoriaDAO.getResultadosDAO().buscarCuadroResultados(param));
		}
		else{
			param.setTerritorio("todos");
			param.setNumTrabajadores("<=49");
			mapa.put(param.getTerritorio()+"|menos49",W83bFactoriaDAO.getResultadosDAO().buscarCuadroResultados(param));
		}
		param.setNumTrabajadores("true");
		return mapa;	
	}
	public java.util.Map buscarCuadroResClasifMayor49(w83b.w83bBeans.W83bResultadosBean param) throws Exception{
		
		Map mapa = new HashMap();
		if (param.getTerritorio()!=null&&!"null".equals(param.getTerritorio())&&!"".equals(param.getTerritorio())){
			param.setNumTrabajadores(">49");
			mapa.put(param.getTerritorio()+"|mas49",W83bFactoriaDAO.getResultadosDAO().buscarCuadroResultados(param));
			param.setCaso("2");
		}
		else{
			param.setTerritorio("todos");
			param.setNumTrabajadores(">49");
			mapa.put(param.getTerritorio()+"|mas49",W83bFactoriaDAO.getResultadosDAO().buscarCuadroResultados(param));
			param.setCaso("4");
		}
		return mapa;	
	}
	
	/* (non-Javadoc)
	 * @see w83b.w83bManager.W83bIResultados#buscarResultadosSexo(w83b.w83bBeans.W83bResultadosBean)
	 */
	public java.util.List buscarResultadosSexo(w83b.w83bBeans.W83bResultadosBean param) throws Exception{

		
//		List listaActas = W83bFactoriaDAO.getResultadosDAO().buscarResultadosSexo(param);
		List listaActas = W83bFactoriaDAO.getResultadosDAO().buscarResultadosPorSexo(param);
//		Iterator itList = listaActas.iterator();
//		W83bActasBean current = new W83bActasBean();
//		long total = 0;
//		int i=0;
//		while(itList.hasNext()){
//			long milis = System.currentTimeMillis();
//			current=(W83bActasBean) itList.next();
//			//buscar en tabla escrutinio la info, si existe obtengo datos de nmero delegados, si no los pongo a 0
//			W83bEscrutinioBean resultadoEscrutinio = W83bFactoriaDAO.getResultadosDAO().buscarActaEnEscrutinio(current);
//			W83bDiferenciasBean resultadodiferencias = W83bFactoriaDAO.getResultadosDAO().buscarActaEnDiferencias(current);
//			if(resultadoEscrutinio==null){
//				current.setDelegadosHombres("0");
//				current.setDelegadosMujeres("0");
//			}else{
//				current.setDelegadosHombres(resultadoEscrutinio.getDelegadosHombres());
//				current.setDelegadosMujeres(resultadoEscrutinio.getDelegadosMujeres());
//			}
//			if(resultadodiferencias!=null){
//				current.setDelegadosHombres(String.valueOf(Integer.parseInt(resultadodiferencias.getNumDelegadosHombres())+Integer.parseInt(current.getDelegadosHombres())));
//				current.setDelegadosMujeres(String.valueOf(Integer.parseInt(resultadodiferencias.getNumDelegadosMujeres())+Integer.parseInt(current.getDelegadosMujeres())));
//			}
//			resultado.add(current);
//			W83bClsTrazas.trazaError(null,"buscar resultados por Sexo OK -> "+ (System.currentTimeMillis()-milis) + " ms - total "+total+" ms - num:"+i,null);
//			i++;
//			total = (System.currentTimeMillis()-milis) + total;
//		}

		return listaActas;
	}
	/* (non-Javadoc)
	 * @see w83b.w83bManager.W83bIResultados#buscarDelegadosConvenio(w83b.w83bBeans.W83bResultadosBean)
	 */
	public java.util.Map buscarDelegadosConvenio(w83b.w83bBeans.W83bResultadosBean param, boolean contar) throws Exception{
	
		Map general=new HashMap();
		List lista;
//		String sector="";
//        int codconvenio=-1;
//        int codsindicato=-1;
//        String descsindicato="";
//        int numdelegados=0;
//        String descsector="";
//        List sindicatos=new ArrayList();
//        Map convenios=new HashMap();
//        boolean encontrado=false;
//        int posicion=0;
//        String descconvenio="";
//        String deseconvenio="";
//        int totalelectores=0;
//        List empresas = new ArrayList();
//        List centros = new ArrayList();
//        List actas = new ArrayList();
//        List actas2 = new ArrayList();
//        String[] valores;
//        int numvotos=0;
//        int cod=0;
        
        
        
        if (!"true".equals(param.getDetalleCentro())){
        	List numempresasycentros = new ArrayList();
        	
        	if(!contar & (-1!=param.getModo().indexOf("ultimaIt")||(param.getMin().equals(param.getMax())))){
        		numempresasycentros=W83bFactoriaDAO.getResultadosDAO().obtenerNumEmpresasYCentros(param);
        	}
        	lista= W83bFactoriaDAO.getResultadosDAO().buscarDelegadosConvenio(param,contar);
        	
        	general.put("numempresasycentros", numempresasycentros);
        	general.put("lista", lista);
        	
    		return general;	
        }
        else{
        	    	
        	lista= W83bFactoriaDAO.getResultadosDAO().buscarDelegConvDetCentro(param,contar);       	
        	general.put("lista", lista);
        	
    		return general;		
        }
        
	}
	
	/* (non-Javadoc)
	 * @see w83b.w83bManager.W83bIResultados#buscarDelegadosConvenio(w83b.w83bBeans.W83bResultadosBean)
	 */
	public java.util.Map buscarRepresentantesCandTamEmp(w83b.w83bBeans.W83bResultadosBean param) throws Exception{
	

		List lista;
		
         
       
		 HashMap datosCompleto=new HashMap();
	        HashMap datosPorMunicipioComarca=new HashMap();
	        HashMap datosPorSindicato=new HashMap();
	        HashMap datosResultado=new HashMap();
	      
	      
	        int resul=0;
	        int resulT=0;
	      
	       W83bResultadosBean datos;
	        W83bResultadosBean lb;
	      
	      
	        
	        lista= W83bFactoriaDAO.getResultadosDAO().buscarRepresentantesCandTamEmp(param);
	       
	        HashMap mapaProvMuniComar=this. obtenerHashMapsProvMunicComar(lista);
	        
	        HashMap hashProvincias=(HashMap)mapaProvMuniComar.get("provincias");
	        HashMap hashMunicipios = (HashMap)mapaProvMuniComar.get("municipios");
	        HashMap hashComarcas=(HashMap)mapaProvMuniComar.get("comarcas");
	       
	        for (int i=0;i<lista.size();i++){
	        	lb = (W83bResultadosBean)lista.get(i);
	        	lb=this.rellenarDatosProvComarcaMunicipio(lb,hashProvincias,hashMunicipios,hashComarcas);
			}
	        for(int i=0;i<lista.size();i++){
	      
		   
	        	 
			   datos=(w83b.w83bBeans.W83bResultadosBean)lista.get(i);
			   if(StringUtils.isNotEmpty(datos.getNumTrabajadoresCentro())
					   && 6<=Integer.parseInt(datos.getNumTrabajadoresCentro())
					   && StringUtils.isNotEmpty(datos.getCodsindicato())
					   && StringUtils.isNotEmpty(datos.getNumdelegados())
					   && 0<Integer.parseInt(datos.getNumdelegados()))
				  {
				   if("comarca".equals(param.getComarcaMunicipio()))
					{
					   
					   if(datosCompleto.containsKey(datos.getCodprovincia().concat("_").concat(datos.getCodcomarca()))){
						   datosPorMunicipioComarca=(HashMap)datosCompleto.get(datos.getCodprovincia().concat("_").concat(datos.getCodcomarca()));
						  
					   }else{
						   datosPorMunicipioComarca=new HashMap();//NOPMD
						  
					   }
					}else{
						if(datosCompleto.containsKey(datos.getCodprovincia().concat("_").concat(datos.getCodcomarca()).concat("_").concat(datos.getCodmunicipio()))){
							   datosPorMunicipioComarca=(HashMap)datosCompleto.get(datos.getCodprovincia().concat("_").concat(datos.getCodcomarca()).concat("_").concat(datos.getCodmunicipio()));
						   }else{
							   datosPorMunicipioComarca=new HashMap();//NOPMD
							   
						   }
					  
					}
				  if(StringUtils.isEmpty((String)datosPorMunicipioComarca.get("codmunicipio")))
				  {
					  datosPorMunicipioComarca.put("codmunicipio", datos.getCodmunicipio());
					  datosPorMunicipioComarca.put("codcomarca", datos.getCodcomarca());
					  datosPorMunicipioComarca.put("codprovincia", datos.getCodprovincia());
					  datosPorMunicipioComarca.put("municipioTxt", datos.getMunicipio());
					  datosPorMunicipioComarca.put("provinciaTxt", datos.getProvincia());
					  datosPorMunicipioComarca.put("comarcaTxt", datos.getComarca());
					 
					  datosPorMunicipioComarca.put("tramo1Total",new Integer(W83bClsConstantes.ZERO));//NOPMD
					  datosPorMunicipioComarca.put("tramo2Total",new Integer(W83bClsConstantes.ZERO));//NOPMD
					  datosPorMunicipioComarca.put("tramo3Total",new Integer(W83bClsConstantes.ZERO));//NOPMD
					  datosPorMunicipioComarca.put("tramo4Total",new Integer(W83bClsConstantes.ZERO));//NOPMD
					  datosPorMunicipioComarca.put("tramo5Total",new Integer(W83bClsConstantes.ZERO));//NOPMD
					  datosPorMunicipioComarca.put("tramo6Total",new Integer(W83bClsConstantes.ZERO));//NOPMD
					  datosPorMunicipioComarca.put("tramo7Total",new Integer(W83bClsConstantes.ZERO));//NOPMD
					  datosPorMunicipioComarca.put("tramo8Total",new Integer(W83bClsConstantes.ZERO));//NOPMD
					  datosPorMunicipioComarca.put("tramo9Total",new Integer(W83bClsConstantes.ZERO));//NOPMD
					  datosPorMunicipioComarca.put("tramoTotalTotal",new Integer(W83bClsConstantes.ZERO));//NOPMD
					  datosPorMunicipioComarca.put("datosSindicatos", new HashMap());//NOPMD
				  }
				  
				  datosPorSindicato=(HashMap) datosPorMunicipioComarca.get("datosSindicatos");
				  String codSindicato=datos.getCodsindicato();
				  String siglas=datos.getSiglas();
				 
				  if(!W83bClsConstantes.codCCOO.equals(codSindicato)
						  && !W83bClsConstantes.codUGT.equals(codSindicato)
						  && !W83bClsConstantes.codELA.equals(codSindicato)
						  && !W83bClsConstantes.codLAB.equals(codSindicato)
					   && !W83bClsConstantes.codNOSIN.equals(codSindicato))
					   {
						   codSindicato="-1";
						   siglas="BESTEAK/OTROS";
					   }
				  if(datosPorSindicato.containsKey(codSindicato)){
					   datosResultado=(HashMap)datosPorSindicato.get(codSindicato);
						  
				   }else{
					  
					   datosResultado=new HashMap();//NOPMD
					   datosResultado.put("codsindicato",codSindicato);
					   datosResultado.put("siglas",siglas);
					   datosResultado.put("tramo1",new Integer(W83bClsConstantes.ZERO));//NOPMD
					   datosResultado.put("tramo2",new Integer(W83bClsConstantes.ZERO));//NOPMD
					   datosResultado.put("tramo3",new Integer(W83bClsConstantes.ZERO));//NOPMD
					   datosResultado.put("tramo4",new Integer(W83bClsConstantes.ZERO));//NOPMD
					   datosResultado.put("tramo5",new Integer(W83bClsConstantes.ZERO));//NOPMD
					   datosResultado.put("tramo6",new Integer(W83bClsConstantes.ZERO));//NOPMD
					   datosResultado.put("tramo7",new Integer(W83bClsConstantes.ZERO));//NOPMD
					   datosResultado.put("tramo8",new Integer(W83bClsConstantes.ZERO));//NOPMD
					   datosResultado.put("tramo9",new Integer(W83bClsConstantes.ZERO));//NOPMD
					   datosResultado.put("tramoTotal",new Integer(W83bClsConstantes.ZERO));//NOPMD
					   
					   datosPorSindicato.put(codSindicato, datosResultado);
					   
					   
					  
				   }
				 
					  int numTrab=Integer.parseInt(datos.getNumTrabajadoresCentro());
						 if(6<=numTrab && numTrab<=10){
							 resul=(((Integer)datosResultado.get("tramo1")).intValue())  + Integer.parseInt(datos.getNumdelegados());
							 datosResultado.put("tramo1",new Integer(resul));//NOPMD
							 resulT=(((Integer)datosPorMunicipioComarca.get("tramo1Total")).intValue()) + Integer.parseInt(datos.getNumdelegados());
							 datosPorMunicipioComarca.put("tramo1Total",new Integer(resulT));//NOPMD
									 
						 }else if(11<=numTrab && numTrab<=30){
							 resul=(((Integer)datosResultado.get("tramo2")).intValue())  + Integer.parseInt(datos.getNumdelegados());
							 datosResultado.put("tramo2",new Integer(resul));//NOPMD
							 resulT=(((Integer)datosPorMunicipioComarca.get("tramo2Total")).intValue())  + Integer.parseInt(datos.getNumdelegados());
							 datosPorMunicipioComarca.put("tramo2Total",new Integer(resulT));//NOPMD
						 }else if(31<=numTrab && numTrab<=49){
							 resul=(((Integer)datosResultado.get("tramo3")).intValue()) + Integer.parseInt(datos.getNumdelegados());
							 datosResultado.put("tramo3",new Integer(resul));//NOPMD
							 resulT=(((Integer)datosPorMunicipioComarca.get("tramo3Total")).intValue())  + Integer.parseInt(datos.getNumdelegados());
							 datosPorMunicipioComarca.put("tramo3Total",new Integer(resulT));//NOPMD
						 }else if(50<=numTrab && numTrab<=100){
							 resul=(((Integer)datosResultado.get("tramo4")).intValue())  + Integer.parseInt(datos.getNumdelegados());
							 datosResultado.put("tramo4",new Integer(resul));//NOPMD
							 resulT=(((Integer)datosPorMunicipioComarca.get("tramo4Total")).intValue())  + Integer.parseInt(datos.getNumdelegados());
							 datosPorMunicipioComarca.put("tramo4Total",new Integer(resulT));//NOPMD
						 }else if(101<=numTrab && numTrab<=250){
							 resul=(((Integer)datosResultado.get("tramo5")).intValue())  + Integer.parseInt(datos.getNumdelegados());
							 datosResultado.put("tramo5",new Integer(resul));//NOPMD
							 resulT=(((Integer)datosPorMunicipioComarca.get("tramo5Total")).intValue())  + Integer.parseInt(datos.getNumdelegados());
							 datosPorMunicipioComarca.put("tramo5Total",new Integer(resulT));//NOPMD
						 }else if(251<=numTrab && numTrab<=500){
							 resul=(((Integer)datosResultado.get("tramo6")).intValue())  + Integer.parseInt(datos.getNumdelegados());
							 datosResultado.put("tramo6",new Integer(resul));//NOPMD
							 resulT=(((Integer)datosPorMunicipioComarca.get("tramo6Total")).intValue())  + Integer.parseInt(datos.getNumdelegados());
							 datosPorMunicipioComarca.put("tramo6Total",new Integer(resulT));//NOPMD
						 }else if(501<=numTrab && numTrab<=750){
							 resul=(((Integer)datosResultado.get("tramo7")).intValue())  + Integer.parseInt(datos.getNumdelegados());
							 datosResultado.put("tramo7",new Integer(resul));//NOPMD
							 resulT=(((Integer)datosPorMunicipioComarca.get("tramo7Total")).intValue())  + Integer.parseInt(datos.getNumdelegados());
							 datosPorMunicipioComarca.put("tramo7Total",new Integer(resulT));//NOPMD
						 }else if(751<=numTrab && numTrab<=1000){
							 resul=(((Integer)datosResultado.get("tramo8")).intValue())  + Integer.parseInt(datos.getNumdelegados());
							 datosResultado.put("tramo8",new Integer(resul));//NOPMD
							 resulT=(((Integer)datosPorMunicipioComarca.get("tramo8Total")).intValue())  + Integer.parseInt(datos.getNumdelegados());
							 datosPorMunicipioComarca.put("tramo8Total",new Integer(resulT));//NOPMD
						 }else if(numTrab>1000){
							 resul=(((Integer)datosResultado.get("tramo9")).intValue())  + Integer.parseInt(datos.getNumdelegados());
							 datosResultado.put("tramo9",new Integer(resul));//NOPMD
							 resulT=(((Integer)datosPorMunicipioComarca.get("tramo9Total")).intValue())  + Integer.parseInt(datos.getNumdelegados());
							 datosPorMunicipioComarca.put("tramo9Total",new Integer(resulT));//NOPMD
						 }
						 resulT=(((Integer)datosResultado.get("tramoTotal")).intValue())  + Integer.parseInt(datos.getNumdelegados());
						 datosResultado.put("tramoTotal",new Integer(resulT));//NOPMD
						 resulT=(((Integer)datosPorMunicipioComarca.get("tramoTotalTotal")).intValue())  + Integer.parseInt(datos.getNumdelegados());
						 datosPorMunicipioComarca.put("tramoTotalTotal",new Integer(resulT));//NOPMD
						 datosPorSindicato.put(codSindicato, datosResultado);
						 
						 datosPorMunicipioComarca.put("datosSindicatos", datosPorSindicato);
						   
							
							
							if("comarca".equals(param.getComarcaMunicipio()))
								{
								   
								   datosCompleto.put(datos.getCodprovincia().concat("_").concat(datos.getCodcomarca()),datosPorMunicipioComarca);				  
								 
				
								}else{
								   datosCompleto.put(datos.getCodprovincia().concat("_").concat(datos.getCodcomarca()).concat("_").concat(datos.getCodmunicipio()),datosPorMunicipioComarca);			
				
								  
								}
						   
							       	
					    	}
						   
				  }
				 
		
			
       
    		
    		return datosCompleto;	
        
       
        
        
	}
	/* (non-Javadoc)
	 * @see w83b.w83bManager.W83bIResultados#buscarResulPorSectorSindicato(w83b.w83bBeans.W83bResultadosBean)
	 */
	public java.util.Map buscarResulPorSectorSindicato(w83b.w83bBeans.W83bResultadosBean param) throws Exception{
	

		List lista;
		List listaTotales;
		HashMap datosCompleto=new HashMap();
	    HashMap datosPorSector=new HashMap();
	    HashMap datosSindicatos=new HashMap();
	    HashMap datosSindicato=new HashMap();
	    
	    
	    W83bResultadosBean datos;
	    lista= W83bFactoriaDAO.getResultadosDAO().buscarResultadosPorSectorSindicato(param);
	    int numhombresSector=0;
	    int nummujeresSector=0;
	    int numtotalSector=0;
		int numhombres=0;
		int nummujeres=0;
		int numtotal=0;
		int divisor=1;
	    for(int i=0;i<lista.size();i++){
	      datos=(w83b.w83bBeans.W83bResultadosBean)lista.get(i);
	      if(datosCompleto.containsKey(datos.getSector())){
				datosPorSector=(HashMap)datosCompleto.get(datos.getSector());
		  }else{
				datosPorSector=new HashMap();//NOPMD
		  }
					
		  if(StringUtils.isEmpty((String)datosPorSector.get("sector")))
		  {
			  datosPorSector.put("sector", datos.getSector());
			  datosPorSector.put("descsector", datos.getDescsector());
			  datosPorSector.put("numdelegadosh", "0");
			  datosPorSector.put("numdelegadosm","0");
			  datosPorSector.put("numdelegados", "0");
			  datosPorSector.put("porcentajeh", "0");
			  datosPorSector.put("porcentajem", "0");
			  
		  }
		  
		  datosSindicatos=(HashMap) datosPorSector.get("datosSindicatos");
		  if(datosSindicatos==null)
		  {
			  datosSindicatos=new HashMap();//NOPMD
		  }
		  String codSindicato=datos.getCodsindicato();
		 
		  if(StringUtils.isNotEmpty(codSindicato))
		  {
			  
		  
			   datosSindicato=new HashMap();//NOPMD
			   datosSindicato.put("codsindicato",datos.getCodsindicato());
			   datosSindicato.put("siglas",datos.getSiglas());
			   datosSindicato.put("sinddesc",datos.getSinddesc());
			   datosSindicato.put("sinddese",datos.getSinddese());
			   datosSindicato.put("numdelegadosh",datos.getNumdelegadosH());
			   datosSindicato.put("numdelegadosm",datos.getNumdelegadosM());
			   datosSindicato.put("numdelegados",datos.getNumdelegados());
			   numhombres=Integer.parseInt((String)datos.getNumdelegadosH());
			   nummujeres=Integer.parseInt((String)datos.getNumdelegadosM());
			   numtotal=Integer.parseInt((String)datos.getNumdelegados());
			   if(numtotal==0)
			   {
				   divisor=1;
			   }else{
				   divisor=numtotal;
			   }
			  datosSindicato.put("divisor",String.valueOf(divisor));
			  datosSindicatos.put(W83bUtilidades.rellenarCaracter(String.valueOf(numtotal),"0",10,true).concat("_").concat(codSindicato), datosSindicato);
			   
			   //Actualizar los datos del Sector
			   numhombresSector=Integer.parseInt((String)datosPorSector.get("numdelegadosh"))+ numhombres;
			   nummujeresSector=Integer.parseInt((String)datosPorSector.get("numdelegadosm"))+ nummujeres;
			   numtotalSector=Integer.parseInt((String)datosPorSector.get("numdelegados"))+ numtotal;
			   if(numtotalSector==0)
			   {
				   divisor=1;
			   }else{
				   divisor=numtotalSector;
			   }
			   datosPorSector.put("divisor",String.valueOf(divisor));
			   datosPorSector.put("numdelegadosh",String.valueOf(numhombresSector));
			   datosPorSector.put("numdelegadosm",String.valueOf(nummujeresSector));
			   datosPorSector.put("numdelegados",String.valueOf(numtotalSector));
			   datosPorSector.put("datosSindicatos", datosSindicatos);
				datosCompleto.put(datos.getSector(),datosPorSector);	
				
		  }
		}
//	    	if((StringUtils.isEmpty(param.getTerritorio())||null==param.getTerritorio()||"null".equals(param.getTerritorio()))&&!lista.isEmpty()){
//	    		buscamos los totales
	    		List nuevaLista=new ArrayList();
	    		listaTotales= W83bFactoriaDAO.getResultadosDAO().buscarResultadosPorSectorSindicatoTotales(param);
	    		String siglas="";
	    		String codigo="";
	    		String sindicatoC="";
	    		String sindicatoE="";
	    		W83bResultadosBean nuevo=new W83bResultadosBean();
	    		int delH=0;
	    		int delM=0;
	    		int delTotal=0;
	    		
	    		
	    		for(int i=0;i<listaTotales.size();i++){
	    			W83bResultadosBean total=(W83bResultadosBean)listaTotales.get(i);
	    			nuevo=new W83bResultadosBean();//NOPMD
	    			if(i==0){
	    				codigo=total.getCodsindicato();
	    				siglas=total.getSiglas();
	    				sindicatoC=total.getSinddesc();
	    				sindicatoE=total.getSinddese();
	    				delH=Integer.parseInt(total.getNumdelegadosH());
	    				delM=Integer.parseInt(total.getNumdelegadosM());
	    				delTotal=Integer.parseInt(total.getNumdelegados());
	    			}
	    			else if(!codigo.equals(total.getCodsindicato())){
	    				//los metemos en la lista
	    				nuevo.setNumdelegados(String.valueOf(delTotal));
	    				nuevo.setNumdelegadosH(String.valueOf(delH));
	    				nuevo.setNumdelegadosM(String.valueOf(delM));
	    				nuevo.setSiglas(siglas);
	    				nuevo.setSinddesc(sindicatoC);
	    				nuevo.setSinddese(sindicatoE);
	    				if(delTotal==0)
	    				   {
	    					   divisor=1;
	    				   }else{
	    					   divisor=delTotal;
	    				   }
	    				nuevo.setNumTrabajadores(String.valueOf(divisor));
	    				nuevaLista.add(nuevo);
	    				//inicializamos los datos
	    				nuevo=new W83bResultadosBean();//NOPMD
	    				delH=Integer.parseInt(total.getNumdelegadosH());
	    				delM=Integer.parseInt(total.getNumdelegadosM());
	    				delTotal=Integer.parseInt(total.getNumdelegados());
	    				siglas=total.getSiglas();
		    			sindicatoC=total.getSinddesc();
	    				sindicatoE=total.getSinddese();
	    				codigo=total.getCodsindicato();
	    			}
	    			else{
	    				//sumamos
	    				delH=delH+Integer.parseInt(total.getNumdelegadosH());
	    				delM=delM+Integer.parseInt(total.getNumdelegadosM());
	    				delTotal=delTotal+Integer.parseInt(total.getNumdelegados());
	    				
	    			}
	    			
	    		}
	    		nuevo.setNumdelegados(String.valueOf(delTotal));
				nuevo.setNumdelegadosH(String.valueOf(delH));
				nuevo.setNumdelegadosM(String.valueOf(delM));
				nuevo.setSiglas(siglas);
				nuevo.setSinddesc(sindicatoC);
				nuevo.setSinddese(sindicatoE);
				if(delTotal==0)
				   {
					   divisor=1;
				   }else{
					   divisor=delTotal;
				   }
				nuevo.setNumTrabajadores(String.valueOf(divisor));
				nuevaLista.add(nuevo);
				datosCompleto.put("totales", nuevaLista);
//	    	}
					
    		
    		return datosCompleto;	
        
       
        
        
	}
	/**
	 * Rellenar datos prov comarca municipio.
	 *
	 * @param paramLb the param lb
	 * @param hashProvincias the hash provincias
	 * @param hashMunicipios the hash municipios
	 * @param hashComarcas the hash comarcas
	 * @return the w83b resultados bean
	 */
	private W83bResultadosBean rellenarDatosProvComarcaMunicipio(W83bResultadosBean paramLb,HashMap hashProvincias,HashMap hashMunicipios,HashMap hashComarcas)
	{
		W83bResultadosBean lb=paramLb;
		if(1==lb.getCodprovincia().length())
		{
			lb.setCodprovincia("0"+lb.getCodprovincia());
		}
		if(1==lb.getCodmunicipio().length())
		{
			lb.setCodmunicipio("00"+lb.getCodmunicipio());
		}else if(2==lb.getCodmunicipio().length()){
			lb.setCodmunicipio("0"+lb.getCodmunicipio());
		}
		if (((W83bResultadosBean)hashMunicipios.get(lb.getCodprovincia().concat("_").concat(lb.getCodmunicipio())))!=null){
			
			lb.setCodcomarca(((W83bResultadosBean)hashMunicipios.get(lb.getCodprovincia().concat("_").concat(lb.getCodmunicipio()))).getCodcomarca());
			
		}
	
		
		if(lb.getCodcomarca()==null)
		{
				lb.setCodcomarca(W83bClsConstantes.VACIO);
		}else if( lb.getCodcomarca().length()==1)
		{
			lb.setCodcomarca("0"+lb.getCodcomarca());
		}
		
		if (((W83bResultadosBean)hashMunicipios.get(lb.getCodprovincia().concat("_").concat(lb.getCodmunicipio())))!=null){
			lb.setMunicipio(((W83bResultadosBean)hashMunicipios.get(lb.getCodprovincia().concat("_").concat(lb.getCodmunicipio()))).getMunicipio());
		}
		
		lb.setProvincia(((W83bResultadosBean)hashProvincias.get(lb.getCodprovincia())).getProvincia());
		if(StringUtils.isNotEmpty(lb.getCodcomarca()))
		{
			lb.setComarca(((W83bResultadosBean)hashComarcas.get(lb.getCodprovincia().concat("_").concat(lb.getCodcomarca()))).getComarca());
			
		}else{
			lb.setComarca(W83bClsConstantes.VACIO);
		}
		return lb;
	}
	
	/**
	 * Obtener hash maps prov munic comar.
	 *
	 * @param lista the lista
	 * @return the hash map
	 * @throws Exception the exception
	 */
	private HashMap obtenerHashMapsProvMunicComar(List lista) throws Exception
	{
		  List provincias=new ArrayList();
	        for (int i=0;i<lista.size();i++){
	        	if(!provincias.contains(((W83bResultadosBean)lista.get(i)).getCodprovincia()))
	        			{
	        				provincias.add(((W83bResultadosBean)lista.get(i)).getCodprovincia());
	        			}
				
			}
	        
	        HashMap mapa=new HashMap();
	        
	        if(0<lista.size())
	        {
	        	mapa.put("municipios",W83bFactoriaDAO.getResultadosDAO().obtenerHashMapMunicipio(provincias));
	        	mapa.put("comarcas",W83bFactoriaDAO.getResultadosDAO().obtenerHashMapComarca(provincias));
	        	mapa.put("provincias",W83bFactoriaDAO.getResultadosDAO().obtenerHashMapProvincia(provincias));
	        	
	        }else{
	        	mapa.put("municipios",new HashMap());
	        	mapa.put("comarcas",new HashMap());
	        	mapa.put("provincias",new HashMap());
	        }
	        return mapa;
	        
	}
	/* (non-Javadoc)
	 * @see w83b.w83bManager.W83bIResultados#buscarDelegadosConvenio(w83b.w83bBeans.W83bResultadosBean)
	 */
	public java.util.Map buscarDiferenciasPorConvenio(w83b.w83bBeans.W83bResultadosBean param) throws Exception{
	

		List lista= W83bFactoriaDAO.getResultadosDAO().buscarDiferenciasPorConvenio(param);
        return  transformarListaMapDatos(lista);
        
       
        
        
	}
	/* (non-Javadoc)
	 * @see w83b.w83bManager.W83bIResultados#buscarDelegadosConvenio(w83b.w83bBeans.W83bResultadosBean)
	 */
	public java.util.Map buscarResulPorEscrutinio(w83b.w83bBeans.W83bResultadosBean param) throws Exception{
	

		List lista= W83bFactoriaDAO.getResultadosDAO().buscarResulPorEscrutinio(param);
        return  transformarListaMapDatos(lista);
        
       
        
        
	}
	
	/**
	 * Transformar lista map datos.
	 *
	 * @param lista the lista
	 * @return the java.util. map
	 * @throws Exception the exception
	 */
	private java.util.Map transformarListaMapDatos(List lista) throws Exception
	{
		HashMap resulMap=new HashMap();
		HashMap mapaProvMuniComar=this. obtenerHashMapsProvMunicComar(lista);
        
        HashMap hashProvincias=(HashMap)mapaProvMuniComar.get("provincias");
        HashMap hashMunicipios = (HashMap)mapaProvMuniComar.get("municipios");
        HashMap hashComarcas=(HashMap)mapaProvMuniComar.get("comarcas");
      
        W83bResultadosBean lb;
        W83bResultadosBean lbaux;
       int numdelegadosTotal;
//       int numTrabajadoresTotal;
       int numvotosTotal;
        for (int i=0;i<lista.size();i++){
        	
        	lb = (W83bResultadosBean)lista.get(i);
        	lb=this.rellenarDatosProvComarcaMunicipio(lb,hashProvincias,hashMunicipios,hashComarcas);
				String key= "";
				if(StringUtils.isNotEmpty(lb.getCodcolegio())){
					//W83bClsTrazas.trazaError(null, "4 -"+lb.getNacta(),null);
					key = lb.getNacta().substring(0,2).concat("/").concat(lb.getNacta().substring(8,lb.getNacta().length())).concat("/").concat(lb.getNacta().substring(3,7)).concat("_").concat(lb.getCodcolegio());
				}else{
					//W83bClsTrazas.trazaError(null, "5-"+lb.getNacta(),null);
					key = lb.getNacta().substring(0,2).concat("/").concat(lb.getNacta().substring(8,lb.getNacta().length())).concat("/").concat(lb.getNacta().substring(3,7)).concat("_");
				}
				if(resulMap.containsKey(key))
				{
					lbaux=(W83bResultadosBean) resulMap.get(key);
				
					numdelegadosTotal=Integer.parseInt(lbaux.getNumdelegados())+Integer.parseInt(lb.getNumdelegados());
					lbaux.setNumdelegados(String.valueOf(numdelegadosTotal));
//					numTrabajadoresTotal=/*Integer.parseInt(lbaux.getNumTrabajadores())+*/Integer.parseInt(lb.getNumTrabajadores());
//					lbaux.setNumTrabajadores((String.valueOf(numTrabajadoresTotal)));
					if(StringUtils.isNotEmpty(lb.getVotos()))
							{
								//numvotosTotal=Integer.parseInt(lbaux.getVotos())+Integer.parseInt(lb.getVotos());
								numvotosTotal=Integer.parseInt(lb.getVotos());
								lbaux.setVotos(String.valueOf(numvotosTotal));
							}
					
					lbaux.setSindicatosDeleg(lbaux.getSindicatosDeleg().concat("\n").concat(lb.getNumdelegados()).concat("  ").concat(W83bUtilidades.convertirAVasioSiNulo(lb.getSiglas())));
				
				}else{
					lbaux=lb;
					lbaux.setSindicatosDeleg(lb.getNumdelegados().concat("  ").concat(W83bUtilidades.convertirAVasioSiNulo(lb.getSiglas())));
					
				}
				resulMap.put(key,lbaux);
		}
        
       return resulMap;
	}
	/* (non-Javadoc)
	 * @see w83b.w83bManager.W83bIResultados#buscarDelegadosConvenio(w83b.w83bBeans.W83bResultadosBean)
	 */
	
	/* (non-Javadoc)
	 * @see w83b.w83bManager.W83bIResultados#existeSector(w83b.w83bBeans.W83bResultadosBean)
	 */
	public java.util.List existeSector(w83b.w83bBeans.W83bResultadosBean param) throws Exception{
		
		List lista= W83bFactoriaDAO.getResultadosDAO().existeSector(param);
		
		return lista;	
	}

	/* (non-Javadoc)
	 * @see w83b.w83bManager.W83bIResultados#buscarResultadosCNAE(w83b.w83bBeans.W83bResultadosBean)
	 */
	public List buscarResultadosCNAE(W83bResultadosBean param) throws Exception {
		return W83bFactoriaDAO.getResultadosDAO().buscarResultadosCNAE(param);
	}
	
	public static String rellenarCeros(String pNumero) {
		StringBuffer num = new StringBuffer();//NOPMD
		
		if (pNumero.length()==1){
			num.append("00000").append(pNumero);
		}else if (pNumero.length()==2){
			num.append("0000").append(pNumero);
		}else if (pNumero.length()==3){
			num.append("000").append(pNumero);
		}else if (pNumero.length()==4){
			num.append("00").append(pNumero);
		}else if (pNumero.length()==5){
			num.append("0").append(pNumero);
		}else{
			num.append(pNumero);
		}
		return num.toString();
	}
	
	public java.util.Map buscarDelegAgrupConv(w83b.w83bBeans.W83bResultadosBean param) throws Exception
	{
		HashMap agrupaciones=new HashMap();
		HashMap convenios=new HashMap();
		HashMap sindicatos=new HashMap();
		List lista=W83bFactoriaDAO.getResultadosDAO().buscarDelegAgrupConv(param);
		StringBuffer stragrup=new StringBuffer(W83bClsConstantes.DIEZ);
		StringBuffer strconv=new StringBuffer(W83bClsConstantes.DIEZ);
		StringBuffer strsind=new StringBuffer(W83bClsConstantes.DIEZ);
		String[] valores;
		for (int i=0; i<lista.size();i++){
			W83bResultadosBean rb = (W83bResultadosBean)lista.get(i);
			stragrup=getAgrupacion(rb.getCodagrup().trim(), rb.getDescagrup(), rb.getDeseagrup());
			strconv=getConvenio(rellenarCerosConv(rb.getCodconvenio().trim()), rb.getDescconvenio(), rb.getDeseconvenio());
			strsind=getSindicato(rb.getCodsindicato().trim(), rb.getSinddesc(), rb.getSinddese());
			if (agrupaciones.get(stragrup.toString())==null){
				sindicatos=new HashMap();//NOPMD
				convenios=new HashMap();//NOPMD
				sindicatos.put(strsind.toString(), rellenarCeros(rb.getNumdelegados())+"|"+rb.getCodsindicato());//Aado +"|"+rb.getCodsindicato() porque luego en el excel al ordenar los sindicatos tienen que tener clave diferente
				convenios.put(strconv.toString(),sindicatos);
				agrupaciones.put(stragrup.toString(), convenios);
			}
			else{
				convenios=(HashMap)agrupaciones.get(stragrup.toString());
				if (convenios.get(strconv.toString())==null){
					sindicatos=new HashMap();//NOPMD
					sindicatos.put(strsind.toString(), rellenarCeros(rb.getNumdelegados())+"|"+rb.getCodsindicato());//Aado rellenarCeros para luego ordenar por convenio
					convenios.put(strconv.toString(), sindicatos);
				}
				else{
					if (sindicatos.get(strsind.toString())==null){
						sindicatos.put(strsind.toString(), rellenarCeros(rb.getNumdelegados())+"|"+rb.getCodsindicato());
					}
					else{
						valores=String.valueOf(sindicatos.get(strsind.toString())).split("\\|");
						sindicatos.put(strsind.toString(), rellenarCeros(String.valueOf(Integer.parseInt(valores[0])+Integer.parseInt(rb.getNumdelegados())))+"|"+rb.getCodsindicato());
					}
				}
			}
			
		}
		return agrupaciones;
	}
	
	public StringBuffer getAgrupacion(String codagrupacion, String descagrup, String deseagrup){
		StringBuffer agrupacion=new StringBuffer(W83bClsConstantes.DIEZ);
		agrupacion.append(codagrupacion).append("|").append(descagrup).append("|").append(deseagrup);
		return agrupacion;
	}
	public StringBuffer getConvenio(String codconvenio, String descconv, String deseconv){
		StringBuffer convenio=new StringBuffer(W83bClsConstantes.DIEZ);
		convenio.append(codconvenio).append("|").append(descconv).append("|").append(deseconv);
		return convenio;
	}
	public StringBuffer getSindicato(String codsindicato, String descsind, String desesind){
		StringBuffer sindicato=new StringBuffer(W83bClsConstantes.DIEZ);
		sindicato.append(codsindicato).append("|").append(descsind).append("|").append(desesind);
		return sindicato;
	}
	public static String rellenarCerosConv(String pNumero) {
		StringBuffer num = new StringBuffer();//NOPMD
		
		if (pNumero.length()==1){
			num.append("000").append(pNumero);
		}else if (pNumero.length()==2){
			num.append("00").append(pNumero);
		}else if (pNumero.length()==3){
			num.append("0").append(pNumero);
		}else{
			num.append(pNumero);
		}
		return num.toString();
	}
	
}